// ref.v
//
// Module to provide a 9-bit reference value "ref" according to the Vout
//	parameter.
// 
//	Full output is 5V as this reference is driving a DAC that turns
//	9-bit into 5V.
//
// If this ref is turned into a counter to generate a ramp, soft-start and
//	hiiccup-mode could be modeled.
//
`timescale 1ps/1fs

module ref(
    output reg [8:0] ref );		// reference output driving a 9-bit DAC

    parameter Vout = 1.2;
    real full_range = 5.0;
    integer  numBits = 9;
    real resolution;

    initial begin
	resolution = full_range / (1<<numBits);
	ref = $rtoi( (Vout/resolution) );
	$monitor( "Vout=%g, resolution=%.6e, ref=%d", Vout, resolution, ref );
    end

endmodule
