// clk_timing_and_counter.v

`include "../Verilog_Lib/master_clock.v"
`include "../Verilog_Lib/timing_and_counter.v"

`timescale 1ps/1fs

module clk_timing_and_counter(
    output clk0,
    output clk_dly,			// Clock signal for unit delay
    output clk_a2d,			// Clock signal for A2D
    output clk_integ,			// Clock signal for integration
    output clk_pid_out,			// Clock signal for outputting the PID
    output [10:0] count );		// Counter output to act as a sawtooth for PWM

    parameter half_period = 500;
    parameter master_clk_delay = 10;
    parameter component_delay = 20;

    master_clock  #(
		.delay(master_clk_delay),
		.half_period(half_period)  )  U_CLK( .clk(clk0) );

    timing_and_counter  #(
		.delay(component_delay)  )  U_TIMING( .count(count), .clk_dly(clk_dly), .clk_a2d(clk_a2d), .clk_integ(clk_integ), .clk_pid_out(clk_pid_out), .master_clock(clk0) );

endmodule
