#ifndef COUNTER_WITH_INCREMENT_H
#define COUNTER_WITH_INCREMENT_H

#include "smx_dll.h"

#ifdef __cplusplus
	extern "C" {
#endif

__declspec(dllexport) p_smx_dll_device_spec* smx_dll_get_supported_devices(void);
__declspec(dllexport) p_smx_dll_device_spec  smx_dll_get_device_spec(char* name, SMX_DLL_UINT32 version);

typedef struct t_counter_with_increment_input_bus_pointers {

	p_smx_dll_bus CLK_bus_p;
	p_smx_dll_bus INCREMENT_bus_p;

} s_counter_with_increment_input_bus_pointers, *p_counter_with_increment_input_bus_pointers;

typedef struct t_counter_with_increment_output_bus_pointers {

	p_smx_dll_bus OUT_bus_p;

} s_counter_with_increment_output_bus_pointers, *p_counter_with_increment_output_bus_pointers;

typedef struct t_counter_with_increment_parameter_values {

	SMX_DLL_UINT64 IC;

} s_counter_with_increment_parameter_values, *p_counter_with_increment_parameter_values;

typedef struct t_counter_with_increment_default_pointers {

	p_counter_with_increment_input_bus_pointers	input_bus_pointers_p;
	p_counter_with_increment_output_bus_pointers	output_bus_pointers_p;
	p_counter_with_increment_parameter_values	parameter_values_p;

} s_counter_with_increment_default_pointers, *p_counter_with_increment_default_pointers;

/*
 * counter_with_increment_setup
 *
 *	This function is defined in counter_with_increment_setup.c
 */
void
	counter_with_increment_setup(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * counter_with_increment_set_initial_condition
 *
 *	This function is defined in counter_with_increment_set_initial_condition.c
 */
void
	counter_with_increment_set_initial_condition(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * counter_with_increment_action
 *
 *	This function is defined in counter_with_increment_action.c
 */
void
	counter_with_increment_action(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * counter_with_increment_teardown
 *
 *	This function is defined in counter_with_increment_teardown.c
 */
void
	counter_with_increment_teardown(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * counter_with_increment_assign_default_pointers
 *
 *	This function is defined in smx_dll.c
 */
SMX_DLL_ERROR
	counter_with_increment_assign_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * counter_with_increment_instantiate_default_pointers
 *
 *	This function is defined smx_dll.c
 */
SMX_DLL_ERROR
	counter_with_increment_instantiate_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
		,
		p_counter_with_increment_default_pointers *result
	);

#ifdef __cplusplus
}
#endif

#endif
