#include "counter_with_increment.h"

/*
 * counter_with_increment_input_specs
 *
 *	This is a NULL-terminated list of the device's input buses and their widths.
 *
 *	Values are of the form "busname,width".
 *
 *	Buses without a width are assumed to be pins, identical to a bus of width 1.
 */
static char* counter_with_increment_input_specs[]  = {
	SMX_DLL_CREATE_BUS_SPEC(CLK,1)
	,
	SMX_DLL_CREATE_BUS_SPEC(INCREMENT,4)
	,
	NULL
};

/*
 * counter_with_increment_output_specs
 *
 *	This is a NULL-terminated list of the device's output buses and their widths.
 *
 *	Values are of the form "busname,width".
 *
 *	Buses without a width are assumed to be pins, identical to a bus of width 1.
 */
static char* counter_with_increment_output_specs[] = {
	SMX_DLL_CREATE_BUS_SPEC(OUT,6)
	,
	NULL
};

/*
 * parameter specifications for the counter_with_increment device.
 */
SMX_DLL_PARAMETER_SPEC( counter_with_increment, IC, SMX_DLL_PARAMETER_TYPE_INTEGER_UNSIGNED, 0 );

/*
 * counter_with_increment_parameters
 *
 *	This is a NULL-terminated list of the device's parameters.
 *
 *	Each entry should be a pointer to a struct of type s_smx_dll_parameter_spec.
 */
static p_smx_dll_parameter_spec counter_with_increment_parameters[]   = {
	&( SMX_DLL_PARAMETER_SPEC_NAME( counter_with_increment, IC ) )
	,
	NULL
};

static s_smx_dll_device_spec counter_with_increment_device_spec = {
	.name = "COUNTER_WITH_INCREMENT"
	,
	.version = 1
	,
	.input_specs = (char**)&counter_with_increment_input_specs
	,
	.output_specs = (char**)&counter_with_increment_output_specs
	,
	.parameter_specs = (s_smx_dll_parameter_spec**)counter_with_increment_parameters
	,
	.setup = counter_with_increment_setup
	,
	.set_initial_condition = counter_with_increment_set_initial_condition
	,
	.action = counter_with_increment_action
	,
	.teardown = counter_with_increment_teardown
};

/*
 * supported_devices
 *
 *	This array should contain all of the latest versions of the device
 *		specifications that the DLL supports.
 *
 *	This array will populate the list of devices from which the user can
 *		select when creating a new instance of a DLL-defined digital device
 *		on a schematic.
 */
static p_smx_dll_device_spec supported_devices[] = {
	&counter_with_increment_device_spec
	,
	NULL
};

/*
 * smx_dll_get_supported_devices
 *
 *	This function is declared in counter_with_increment.h
 */
p_smx_dll_device_spec* smx_dll_get_supported_devices(void) {
	return supported_devices;
}

/*
 * smx_dll_get_device_spec
 *
 *	This function is declared in counter_with_increment.h
 */
p_smx_dll_device_spec smx_dll_get_device_spec(
	char* name
	,
	SMX_DLL_UINT32 version
) {

	p_smx_dll_device_spec
		device_spec_p = NULL;

	/*
	 * This automatically generated code is written to insist on an exact
	 *	match of both device name and version in order to return a specification.
	 */
	if(
		0 == _stricmp( "COUNTER_WITH_INCREMENT", name )
		&&
		version == counter_with_increment_device_spec.version
	) {
		device_spec_p = &counter_with_increment_device_spec;
	}

	return device_spec_p;
}

/*
 * counter_with_increment_assign_default_pointers
 *
 *	This function calls counter_with_increment_instantiate_default_pointers and
 *		assigns the result to the device's unmanaged user storage.
 *
 *	There is no reason to call this function more than once, and it is
 *		recommended to be called during counter_with_increment_setup,
 *		not during counter_with_increment_set_initial_condition or counter_with_increment_action.
 */
SMX_DLL_ERROR counter_with_increment_assign_default_pointers(
	p_smx_dll_simulation_context context_p
	,
	p_smx_dll_device device_p
) {

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	p_counter_with_increment_default_pointers
		default_pointers_p = NULL;

	// instantiate default pointers
	if(
		SMX_DLL_NO_ERROR != ( rv = counter_with_increment_instantiate_default_pointers( context_p, device_p, &default_pointers_p ) )
		||
		NULL == default_pointers_p
	) {

		// an error occurred instantiating the pointers
		context_p->funcs->fatal_error( device_p, "Unable to instantiate default pointers." );

		return rv;

	}

	// assign unmanaged user storage size
	device_p->unmanaged_user_storage_size =
		sizeof( s_counter_with_increment_default_pointers );

	// assign default pointers to unmanaged user storage
	device_p->unmanaged_user_storage =
		default_pointers_p;

	return rv;

}

/*
 * counter_with_increment_instantiate_default_pointers
 *
 *	This function will populate a struct of type s_counter_with_increment_default_pointers.
 *
 *	A pointer will be retrieved for each input bus and output bus.
 *
 *	The value will be retrieved for each parameter.
 *
 *	There is no reason to call this function more than once, and it is
 *		recommended to be called during counter_with_increment_setup,
 *		not during counter_with_increment_set_initial_condition or counter_with_increment_action.
 *
 *	This function is called by counter_with_increment_assign_default_pointers, it is
 *		not necessary to call them both.
 */
SMX_DLL_ERROR counter_with_increment_instantiate_default_pointers(
	p_smx_dll_simulation_context context_p
	,
	p_smx_dll_device device_p
	,
	p_counter_with_increment_default_pointers *result
) {

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	p_counter_with_increment_default_pointers
		default_pointers_p = NULL;

	p_counter_with_increment_input_bus_pointers
		input_bus_pointers_p = NULL;

	p_counter_with_increment_output_bus_pointers
		output_bus_pointers_p = NULL;

	p_counter_with_increment_parameter_values
		parameter_values_p = NULL;

	p_smx_dll_parameter
		parameter_p = NULL;

	// instantiate structs
	if( NULL == ( default_pointers_p    = (s_counter_with_increment_default_pointers*   )malloc( sizeof( s_counter_with_increment_default_pointers    ) ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to malloc for default pointers." );
		return SMX_DLL_ERROR_UNABLE_TO_ALLOCATE_MEMORY;
	}
	if( NULL == ( input_bus_pointers_p  = (s_counter_with_increment_input_bus_pointers* )malloc( sizeof( s_counter_with_increment_input_bus_pointers  ) ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to malloc for input bus pointers." );
		return SMX_DLL_ERROR_UNABLE_TO_ALLOCATE_MEMORY;
	}
	if( NULL == ( output_bus_pointers_p = (s_counter_with_increment_output_bus_pointers*)malloc( sizeof( s_counter_with_increment_output_bus_pointers ) ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to malloc for output bus pointers." );
		return SMX_DLL_ERROR_UNABLE_TO_ALLOCATE_MEMORY;
	}
	if( NULL == ( parameter_values_p    = (s_counter_with_increment_parameter_values*   )malloc( sizeof( s_counter_with_increment_parameter_values    ) ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to malloc for parameter_values." );
		return SMX_DLL_ERROR_UNABLE_TO_ALLOCATE_MEMORY;
	}

	// assign pointers
	default_pointers_p->input_bus_pointers_p  = input_bus_pointers_p;
	default_pointers_p->output_bus_pointers_p = output_bus_pointers_p;
	default_pointers_p->parameter_values_p    = parameter_values_p;

	// retrieve input bus pointers, if necessary
	if( SMX_DLL_NO_ERROR != context_p->funcs->get_bus_by_name(device_p, "CLK", SMX_DLL_DIRECTION_INPUT, &( input_bus_pointers_p->CLK_bus_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to locate INPUT bus by name: CLK" );
		return SMX_DLL_ERROR_RESULT_NOT_FOUND;
	}
	if( SMX_DLL_NO_ERROR != context_p->funcs->get_bus_by_name(device_p, "INCREMENT", SMX_DLL_DIRECTION_INPUT, &( input_bus_pointers_p->INCREMENT_bus_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to locate INPUT bus by name: INCREMENT" );
		return SMX_DLL_ERROR_RESULT_NOT_FOUND;
	}

	// retrieve output bus pointers
	if( SMX_DLL_NO_ERROR != context_p->funcs->get_bus_by_name(device_p, "OUT", SMX_DLL_DIRECTION_OUTPUT, &( output_bus_pointers_p->OUT_bus_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to locate OUTPUT bus by name: OUT" );
		return SMX_DLL_ERROR_RESULT_NOT_FOUND;
	}

	// retrieve parameter values
	if( SMX_DLL_NO_ERROR != context_p->funcs->get_parameter_by_name(device_p, "IC", &( parameter_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to locate parameter by name: IC" );
		return SMX_DLL_ERROR_RESULT_NOT_FOUND;
	}
	parameter_values_p->IC = parameter_p->value.uint_value;

	// assign result
	*result = default_pointers_p;

	// pointer and value assignment complete
	return rv;

}
